<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta charset="utf-8" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e($title ?? 'Login'); ?> -  <?php echo e(get_settings('website_name')); ?></title>

    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(assetFromPublic('favicons/apple-touch-icon.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(assetFromPublic('favicons/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(assetFromPublic('favicons/favicon-16x16.png')); ?>">

    <link rel="manifest" href="favicons/site.webmanifest">
    <link rel="mask-icon" href="favicons/safari-pinned-tab.svg" color="#000000">
    <link rel="shortcut icon" href="favicons/favicon.ico">
    <meta name="theme-color" content="#ffffff">



    <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;700">
    <script data-name="static-context">
        Static = window.Static || {};
        Static.SQUARESPACE_CONTEXT = {
            "tweakJSON": {
                "header-logo-height": "40px",
                "header-mobile-logo-max-height": "30px",
                "header-vert-padding": "2.2vw",
                "header-width": "Full",
                "maxPageWidth": "1500px",
                "pagePadding": "4vw",
                "tweak-fixed-header": "true",
                "tweak-fixed-header-style": "Basic",
            },
        };
    </script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(assetFromPublic('css/site.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(assetFromPublic('css/static.css')); ?>" />

    <script src="https://cdn.jsdelivr.net/npm/stimulus@3.2.2/dist/stimulus.umd.min.js"></script>
    <link rel="stylesheet" href="<?php echo e(assetFromPublic('css/app.css')); ?>">
    <style>
        .border-brand-secondary-light {
            border-color: rgb(0 0 0);
        }

        .text-brand-secondary-light {
            color: rgb(0 0 0);
        }

        .bg-brand-secondary-light {
            background-color: rgb(0 0 0);
        }

        .bg-brand-blue {
            background-color: rgba(0 0 0);
        }

        .bg-brand-mid-blue {
            background-color: rgb(218 218 218 / 40%);
        }
    </style>
    <style>
        @media (min-width: 640px) {
            .height-40 {
                height: 40rem;
            }
        }

        .active-plan {
            display: block;
        }

        @media (min-width: 768px) {
            .active-plan {
                display: flex;
            }
        }

        .hidden-plan {
            display: none;
        }
    </style>
    <style>
        @media screen and (min-width: 768px) {
            .sqs-narrow-width {
                flex-direction: row-reverse;
                display: flex;
                -ms-justify-content: space-between;
                justify-content: space-between;
            }

            .sqs-block-image .design-layout-card>div:first-child {
                width: calc(50% - 5%);
            }

            .image-card-wrapper {
                margin-top: unset !important;
                margin-right: 10%;
                -ms-flex-align: center;
                align-items: center;
                display: flex;
                -ms-flex-align: center;
                align-items: center;
                -ms-justify-content: center;
                justify-content: center;
                min-height: 100%;
                position: relative;
                width: calc(50% - 5%);
            }
        }
    </style>

</head>

<body id="collection-5efdef714f580a489c80737d"
    class="primary-button-style-outline primary-button-shape-rounded secondary-button-style-outline secondary-button-shape-rounded tertiary-button-style-outline tertiary-button-shape-rounded  form-field-style-solid form-field-shape-square form-field-border-all form-field-checkbox-type-icon form-field-checkbox-fill-solid form-field-checkbox-color-inverted form-field-checkbox-shape-square form-field-checkbox-layout-stack form-field-radio-type-icon form-field-radio-fill-solid form-field-radio-color-normal form-field-radio-shape-pill form-field-radio-layout-stack form-field-survey-fill-solid form-field-survey-color-normal form-field-survey-shape-pill form-field-hover-focus-outline form-submit-button-style-label header-overlay-alignment-center header-width-full  tweak-fixed-header tweak-fixed-header-style-basic tweak-blog-alternating-side-by-side-width-full tweak-blog-alternating-side-by-side-image-aspect-ratio-11-square tweak-blog-alternating-side-by-side-text-alignment-left tweak-blog-alternating-side-by-side-read-more-style-show tweak-blog-alternating-side-by-side-image-text-alignment-middle tweak-blog-alternating-side-by-side-delimiter-bullet tweak-blog-alternating-side-by-side-meta-position-top tweak-blog-alternating-side-by-side-primary-meta-categories tweak-blog-alternating-side-by-side-secondary-meta-date tweak-blog-alternating-side-by-side-excerpt-show tweak-blog-basic-grid-width-full tweak-blog-basic-grid-image-aspect-ratio-32-standard tweak-blog-basic-grid-text-alignment-left tweak-blog-basic-grid-delimiter-bullet tweak-blog-basic-grid-image-placement-above tweak-blog-basic-grid-read-more-style-show tweak-blog-basic-grid-primary-meta-categories tweak-blog-basic-grid-secondary-meta-date tweak-blog-basic-grid-excerpt-show tweak-blog-item-width-medium tweak-blog-item-text-alignment-left tweak-blog-item-meta-position-above-title tweak-blog-item-show-categories tweak-blog-item-show-date tweak-blog-item-show-author-name tweak-blog-item-show-author-profile tweak-blog-item-delimiter-bullet tweak-blog-masonry-width-full tweak-blog-masonry-text-alignment-left tweak-blog-masonry-primary-meta-categories tweak-blog-masonry-secondary-meta-date tweak-blog-masonry-meta-position-top tweak-blog-masonry-read-more-style-show tweak-blog-masonry-delimiter-space tweak-blog-masonry-image-placement-above tweak-blog-masonry-excerpt-show tweak-blog-side-by-side-width-inset tweak-blog-side-by-side-image-placement-left tweak-blog-side-by-side-image-aspect-ratio-32-standard tweak-blog-side-by-side-primary-meta-categories tweak-blog-side-by-side-secondary-meta-date tweak-blog-side-by-side-meta-position-top tweak-blog-side-by-side-text-alignment-left tweak-blog-side-by-side-image-text-alignment-middle tweak-blog-side-by-side-read-more-style-show tweak-blog-side-by-side-delimiter-bullet tweak-blog-side-by-side-excerpt-show tweak-blog-single-column-width-full tweak-blog-single-column-text-alignment-center tweak-blog-single-column-image-placement-above tweak-blog-single-column-delimiter-bullet tweak-blog-single-column-read-more-style-show tweak-blog-single-column-primary-meta-categories tweak-blog-single-column-secondary-meta-date tweak-blog-single-column-meta-position-top tweak-blog-single-column-content-full-post tweak-events-stacked-width-full tweak-events-stacked-height-large  tweak-events-stacked-show-thumbnails tweak-events-stacked-thumbnail-size-32-standard tweak-events-stacked-date-style-with-text tweak-events-stacked-show-time tweak-events-stacked-show-location  tweak-events-stacked-show-excerpt   tweak-global-animations-complexity-level-detailed tweak-global-animations-animation-style-fade tweak-global-animations-animation-type-none tweak-global-animations-animation-curve-ease tweak-portfolio-grid-basic-width-full tweak-portfolio-grid-basic-height-small tweak-portfolio-grid-basic-image-aspect-ratio-43-four-three tweak-portfolio-grid-basic-text-alignment-left tweak-portfolio-grid-basic-hover-effect-fade tweak-portfolio-grid-overlay-width-full tweak-portfolio-grid-overlay-height-small tweak-portfolio-grid-overlay-image-aspect-ratio-43-four-three tweak-portfolio-grid-overlay-text-placement-center tweak-portfolio-grid-overlay-show-text-after-hover tweak-portfolio-index-background-link-format-stacked tweak-portfolio-index-background-width-full-bleed tweak-portfolio-index-background-height-large  tweak-portfolio-index-background-vertical-alignment-middle tweak-portfolio-index-background-horizontal-alignment-center tweak-portfolio-index-background-delimiter-none tweak-portfolio-index-background-animation-type-scale-up tweak-portfolio-index-background-animation-duration-medium tweak-portfolio-hover-follow-layout-stacked tweak-portfolio-hover-follow-front tweak-portfolio-hover-follow-delimiter-forward-slash tweak-portfolio-hover-follow-animation-type-scale-up tweak-portfolio-hover-follow-animation-duration-medium tweak-portfolio-hover-static-layout-stacked tweak-portfolio-hover-static-front tweak-portfolio-hover-static-delimiter-forward-slash tweak-portfolio-hover-static-animation-type-scale-up tweak-portfolio-hover-static-animation-duration-medium tweak-product-basic-item-product-variant-display-dropdown tweak-product-basic-item-width-full tweak-product-basic-item-gallery-aspect-ratio-34-three-four-vertical tweak-product-basic-item-text-alignment-left tweak-product-basic-item-navigation-both tweak-product-basic-item-content-alignment-top tweak-product-basic-item-gallery-design-slideshow tweak-product-basic-item-gallery-placement-left tweak-product-basic-item-thumbnail-placement-side tweak-product-basic-item-click-action-none tweak-product-basic-item-hover-action-none tweak-product-basic-item-variant-picker-layout-dropdowns tweak-products-width-full tweak-products-image-aspect-ratio-11-square tweak-products-text-alignment-left  tweak-products-price-show tweak-products-nested-category-type-top tweak-products-category-title tweak-products-header-text-alignment-middle tweak-products-breadcrumbs image-block-poster-text-alignment-left image-block-card-content-position-center image-block-card-text-alignment-left image-block-overlap-content-position-center image-block-overlap-text-alignment-left image-block-collage-content-position-center image-block-collage-text-alignment-left image-block-stack-text-alignment-left hide-opentable-icons opentable-style-dark tweak-product-quick-view-button-style-floating tweak-product-quick-view-button-position-bottom tweak-product-quick-view-lightbox-excerpt-display-truncate tweak-product-quick-view-lightbox-show-arrows tweak-product-quick-view-lightbox-show-close-button tweak-product-quick-view-lightbox-controls-weight-light native-currency-code-usd collection-type-page collection-layout-default collection-5efdef714f580a489c80737d homepage mobile-style-available sqs-seven-one show-pdp-product-add-ons"
    data-description="plp-mobile-editor-column" tabindex="-1" style="--heading-font-font-family: Poppins;">
    <div id="siteWrapper" class="clearfix site-wrapper">

        <header data-test="header" id="header" class="header theme-col--primary" data-section-theme=""
            data-controller="Header"
            data-current-styles="{
&quot;layout&quot;: &quot;navRight&quot;,
&quot;action&quot;: {
&quot;buttonText&quot;: &quot;Direkt Loslegen&quot;,
&quot;newWindow&quot;: false
},
&quot;showSocial&quot;: false,
&quot;socialOptions&quot;: {
&quot;socialBorderShape&quot;: &quot;none&quot;,
&quot;socialBorderStyle&quot;: &quot;outline&quot;,
&quot;socialBorderThickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 1.0
}
},
&quot;menuOverlayAnimation&quot;: &quot;fade&quot;,
&quot;cartStyle&quot;: &quot;cart&quot;,
&quot;cartText&quot;: &quot;Cart&quot;,
&quot;showEmptyCartState&quot;: true,
&quot;cartOptions&quot;: {
&quot;iconType&quot;: &quot;solid-7&quot;,
&quot;cartBorderShape&quot;: &quot;none&quot;,
&quot;cartBorderStyle&quot;: &quot;outline&quot;,
&quot;cartBorderThickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 1.0
}
},
&quot;showButton&quot;: false,
&quot;showCart&quot;: false,
&quot;showAccountLogin&quot;: true,
&quot;headerStyle&quot;: &quot;theme&quot;,
&quot;languagePicker&quot;: {
&quot;enabled&quot;: false,
&quot;iconEnabled&quot;: false,
&quot;iconType&quot;: &quot;globe&quot;,
&quot;flagShape&quot;: &quot;shiny&quot;,
&quot;languageFlags&quot;: [ ]
},
&quot;mobileOptions&quot;: {
&quot;layout&quot;: &quot;logoLeftNavRight&quot;,
&quot;menuIcon&quot;: &quot;doubleLineHamburger&quot;,
&quot;menuIconOptions&quot;: {
&quot;style&quot;: &quot;doubleLineHamburger&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 1.0
}
}
},
&quot;dynamicOptions&quot;: {
&quot;border&quot;: {
&quot;enabled&quot;: false,
&quot;position&quot;: &quot;bottom&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 4.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
}
},
&quot;solidOptions&quot;: {
&quot;headerOpacity&quot;: {
&quot;unit&quot;: &quot;%&quot;,
&quot;value&quot;: 100.0
},
&quot;border&quot;: {
&quot;enabled&quot;: false,
&quot;position&quot;: &quot;bottom&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 4.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;dropShadow&quot;: {
&quot;enabled&quot;: false,
&quot;blur&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 30.0
},
&quot;spread&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;distance&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;blurBackground&quot;: {
&quot;enabled&quot;: false,
&quot;blurRadius&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
}
},
&quot;backgroundColor&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;white&quot;,
&quot;alphaModifier&quot;: 1.0
}
},
&quot;navigationColor&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;gradientOptions&quot;: {
&quot;gradientType&quot;: &quot;faded&quot;,
&quot;headerOpacity&quot;: {
&quot;unit&quot;: &quot;%&quot;,
&quot;value&quot;: 90.0
},
&quot;border&quot;: {
&quot;enabled&quot;: false,
&quot;position&quot;: &quot;bottom&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 4.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;dropShadow&quot;: {
&quot;enabled&quot;: false,
&quot;blur&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 30.0
},
&quot;spread&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;distance&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;blurBackground&quot;: {
&quot;enabled&quot;: false,
&quot;blurRadius&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
}
},
&quot;backgroundColor&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;white&quot;,
&quot;alphaModifier&quot;: 1.0
}
},
&quot;navigationColor&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;dropShadowOptions&quot;: {
&quot;enabled&quot;: false,
&quot;blur&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
},
&quot;spread&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;distance&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
}
},
&quot;borderOptions&quot;: {
&quot;enabled&quot;: false,
&quot;position&quot;: &quot;bottom&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 4.0
}
},
&quot;showPromotedElement&quot;: false,
&quot;buttonVariant&quot;: &quot;primary&quot;,
&quot;blurBackground&quot;: {
&quot;enabled&quot;: false,
&quot;blurRadius&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
}
},
&quot;headerOpacity&quot;: {
&quot;unit&quot;: &quot;%&quot;,
&quot;value&quot;: 100.0
}
}"
            data-section-id="header" data-header-theme="" data-menu-overlay-theme="" data-header-style="theme"
            data-language-picker="{
&quot;enabled&quot;: false,
&quot;iconEnabled&quot;: false,
&quot;iconType&quot;: &quot;globe&quot;,
&quot;flagShape&quot;: &quot;shiny&quot;,
&quot;languageFlags&quot;: [ ]
}"
            data-first-focusable-element tabindex="-1"
            style="
        --solidHeaderBackgroundColor: hsla(var(--white-hsl), 1);
        --solidHeaderNavigationColor: hsla(var(--black-hsl), 1);
        --gradientHeaderBackgroundColor: hsla(var(--white-hsl), 1);
        --gradientHeaderNavigationColor: hsla(var(--black-hsl), 1);
    ">
            <div class="sqs-announcement-bar-dropzone"></div>
            <div class="header-announcement-bar-wrapper">
                <a href="#page" class="header-skip-link sqs-button-element--primary">
                    Skip to Content
                </a>
                <style>
                    @supports (-webkit-backdrop-filter: none) or (backdrop-filter: none) {
                        .header-blur-background {}
                    }
                </style>
                <div class="header-border" data-header-style="theme" data-header-usability-enabled="true"
                    data-header-border="false" data-test="header-border" style=""></div>
                <div class="header-dropshadow" data-header-style="theme" data-header-usability-enabled="true"
                    data-header-dropshadow="false" data-test="header-dropshadow" style=""></div>


                <div class='header-inner container--fluid header-mobile-layout-logo-left-nav-right header-layout-nav-right'
                    style="" data-test="header-inner">
                    <!-- Background -->
                    <div class="header-background theme-bg--primary"></div>
                    <div class="header-display-desktop" data-content-field="site-title">
                        <!-- Social -->
                        <!-- Title and nav wrapper -->
                        <div class="header-title-nav-wrapper">
                            <!-- Title -->
                            <div class="header-title" data-animation-role="header-element">
                                <div class="header-title-logo">
                                    <a href="<?php echo e(url('/')); ?>" data-animation-role="header-element">
                                        <img elementtiming="nbf-header-logo-desktop"
                                            src="<?php echo e(image_url(get_settings('site_logo'))); ?>" alt="<?php echo e(get_settings('website_name')); ?>"
                                            style="display:block" fetchpriority="high" loading="eager" decoding="async"
                                            data-loader="raw">
                                    </a>
                                </div>
                            </div>

                            <!-- Nav -->
                            <div class="header-nav">
                                <div class="header-nav-wrapper">
                                    <nav class="header-nav-list" style="align-items: center;">
                                        <div
                                            class="header-nav-item header-nav-item--collection header-nav-item--homepage header-nav-item--active">
                                            <a href="<?php echo e(url('/')); ?>" data-animation-role="header-element">
                                                Home
                                            </a>
                                        </div>
                                        <div class="header-nav-item header-nav-item--collection">
                                            <a href="<?php echo e(url('about-us')); ?>" data-animation-role="header-element">
                                                About
                                            </a>
                                        </div>
                                        
                                        <div class="header-nav-item header-nav-item--collection">
                                            <a href="<?php echo e(url('contact-us')); ?>" data-animation-role="header-element">
                                                Contact
                                            </a>
                                        </div>
                                        <div class="header-nav-item header-nav-item--folder">
                                            <a class="header-nav-folder-title" href="#" tabindex="-1"
                                                data-animation-role="header-element">
                                                Markets
                                            </a>
                                            <div class="header-nav-folder-content">
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/forex')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Forex
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/indices')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Indices
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/commodities')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Commodities
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/shares')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Shares
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/cryptocurrency')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Cryptocurrencies
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/economic-calender')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Economic Calender
                                                        </span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(Auth::user()): ?>
                                            <div class="header-nav-item header-nav-item--collection">
                                                <a href="<?php echo e(url('user/dashboard')); ?>"
                                                    class="sqs-block-button-element--small sqs-button-element--tertiary sqs-block-button-element"
                                                    style="padding:10px;">
                                                    Dashboard
                                                </a>
                                            </div>
                                        <?php else: ?>
                                            <div class="header-nav-item header-nav-item--collection">
                                                <a href="<?php echo e(url('register')); ?>"
                                                    class="sqs-block-button-element--small sqs-button-element--tertiary sqs-block-button-element"
                                                    style="padding:10px;">
                                                    Join Us
                                                </a>
                                            </div>
                                            <div class="header-nav-item header-nav-item--collection">
                                                <a href="<?php echo e(url('login')); ?>"
                                                    class="sqs-block-button-element--small sqs-button-element--tertiary sqs-block-button-element"
                                                    style="padding:10px;">
                                                    Login
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </nav>

                                </div>
                            </div>
                        </div>
                        <!-- Actions -->
                        <div class="header-actions header-actions--right">
                            <div class="showOnMobile">
                            </div>
                            <div class="showOnDesktop">
                            </div>
                        </div>
                        <style>
                            .top-bun,
                            .patty,
                            .bottom-bun {
                                height: 1px;
                            }
                        </style>
                        <!-- Burger -->
                        <div class="header-burger menu-overlay-has-visible-non-navigation-items no-actions"
                            data-animation-role="header-element">
                            <button class="header-burger-btn burger" data-test="header-burger">
                                <span hidden class="js-header-burger-open-title visually-hidden">Open Menu</span>
                                <span hidden class="js-header-burger-close-title visually-hidden">Close Menu</span>
                                <div class="burger-box">
                                    <div class="burger-inner header-menu-icon-doubleLineHamburger">
                                        <div class="top-bun"></div>
                                        <div class="patty"></div>
                                        <div class="bottom-bun"></div>
                                    </div>
                                </div>
                            </button>
                        </div>
                    </div>
                    <div class="header-display-mobile" data-content-field="site-title">
                        <!-- Social -->
                        <!-- Title and nav wrapper -->
                        <div class="header-title-nav-wrapper">
                            <!-- Title -->
                            <div class="header-title" data-animation-role="header-element">
                                <div class="header-title-logo">
                                    <a href="/" data-animation-role="header-element">
                                        <img elementtiming="nbf-header-logo-desktop"
                                            src="<?php echo e(image_url(get_settings('site_logo'))); ?>" alt="<?php echo e(get_settings('website_name')); ?>"
                                            style="display:block" fetchpriority="high" loading="eager"
                                            decoding="async" data-loader="raw">
                                    </a>
                                </div>
                            </div>

                            <!-- Nav -->
                            <div class="header-nav">
                                <div class="header-nav-wrapper">
                                    <nav class="header-nav-list" style="align-items: center;">
                                        <div
                                            class="header-nav-item header-nav-item--collection header-nav-item--homepage header-nav-item--active">
                                            <a href="<?php echo e(url('/')); ?>" data-animation-role="header-element">
                                                Home
                                            </a>
                                        </div>
                                        <div class="header-nav-item header-nav-item--collection">
                                            <a href="<?php echo e(url('about-us')); ?>" data-animation-role="header-element">
                                                About
                                            </a>
                                        </div>
                                        <div class="header-nav-item header-nav-item--collection">
                                            <a href="<?php echo e(url('pricing')); ?>" data-animation-role="header-element">
                                                Pricing
                                            </a>
                                        </div>
                                        <div class="header-nav-item header-nav-item--collection">
                                            <a href="<?php echo e(url('contact-us')); ?>" data-animation-role="header-element">
                                                Contact
                                            </a>
                                        </div>
                                        <div class="header-nav-item header-nav-item--folder">
                                            <a class="header-nav-folder-title" href="#" tabindex="-1"
                                                data-animation-role="header-element">
                                                Markets
                                            </a>
                                            <div class="header-nav-folder-content">
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('/markets/forex')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Forex
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/indices')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Indices
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/commodities')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Commodities
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/shares')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Shares
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/cryptocurrency')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Cryptocurrencies
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="header-nav-folder-item">
                                                    <a href="<?php echo e(url('markets/economic-calender')); ?>">
                                                        <span class="header-nav-folder-item-content">
                                                            Economic Calender
                                                        </span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(Auth::user()): ?>
                                            <div class="header-nav-item header-nav-item--collection">
                                                <a href="<?php echo e(url('user/dashboard')); ?>"
                                                    class="sqs-block-button-element--small sqs-button-element--tertiary sqs-block-button-element"
                                                    style="padding:10px;">
                                                    Dashboard
                                                </a>
                                            </div>
                                        <?php else: ?>
                                            <div class="header-nav-item header-nav-item--collection">
                                                <a href="<?php echo e(url('register')); ?>"
                                                    class="sqs-block-button-element--small sqs-button-element--tertiary sqs-block-button-element"
                                                    style="padding:10px;">
                                                    Join Us
                                                </a>
                                            </div>
                                            <div class="header-nav-item header-nav-item--collection">
                                                <a href="<?php echo e(url('login')); ?>"
                                                    class="sqs-block-button-element--small sqs-button-element--tertiary sqs-block-button-element"
                                                    style="padding:10px;">
                                                    Login
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </nav>

                                </div>
                            </div>
                        </div>
                        <!-- Actions -->
                        <div class="header-actions header-actions--right">
                            <div class="showOnMobile">
                            </div>
                            <div class="showOnDesktop">
                            </div>
                        </div>
                        <style>
                            .top-bun,
                            .patty,
                            .bottom-bun {
                                height: 1px;
                            }
                        </style>
                        <!-- Burger -->
                        <div class="header-burger menu-overlay-has-visible-non-navigation-items no-actions"
                            data-animation-role="header-element">
                            <button class="header-burger-btn burger" data-test="header-burger">
                                <span hidden class="js-header-burger-open-title visually-hidden">Open Menu</span>
                                <span hidden class="js-header-burger-close-title visually-hidden">Close Menu</span>
                                <div class="burger-box">
                                    <div class="burger-inner header-menu-icon-doubleLineHamburger">
                                        <div class="top-bun"></div>
                                        <div class="patty"></div>
                                        <div class="bottom-bun"></div>
                                    </div>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- (Mobile) Menu Navigation -->
            <div class="header-menu header-menu--folder-list" data-section-theme=""
                data-current-styles="{
&quot;layout&quot;: &quot;navRight&quot;,
&quot;action&quot;: {
&quot;buttonText&quot;: &quot;Direkt Loslegen&quot;,
&quot;newWindow&quot;: false
},
&quot;showSocial&quot;: false,
&quot;socialOptions&quot;: {
&quot;socialBorderShape&quot;: &quot;none&quot;,
&quot;socialBorderStyle&quot;: &quot;outline&quot;,
&quot;socialBorderThickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 1.0
}
},
&quot;menuOverlayAnimation&quot;: &quot;fade&quot;,
&quot;cartStyle&quot;: &quot;cart&quot;,
&quot;cartText&quot;: &quot;Cart&quot;,
&quot;showEmptyCartState&quot;: true,
&quot;cartOptions&quot;: {
&quot;iconType&quot;: &quot;solid-7&quot;,
&quot;cartBorderShape&quot;: &quot;none&quot;,
&quot;cartBorderStyle&quot;: &quot;outline&quot;,
&quot;cartBorderThickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 1.0
}
},
&quot;showButton&quot;: false,
&quot;showCart&quot;: false,
&quot;showAccountLogin&quot;: true,
&quot;headerStyle&quot;: &quot;theme&quot;,
&quot;languagePicker&quot;: {
&quot;enabled&quot;: false,
&quot;iconEnabled&quot;: false,
&quot;iconType&quot;: &quot;globe&quot;,
&quot;flagShape&quot;: &quot;shiny&quot;,
&quot;languageFlags&quot;: [ ]
},
&quot;mobileOptions&quot;: {
&quot;layout&quot;: &quot;logoLeftNavRight&quot;,
&quot;menuIcon&quot;: &quot;doubleLineHamburger&quot;,
&quot;menuIconOptions&quot;: {
&quot;style&quot;: &quot;doubleLineHamburger&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 1.0
}
}
},
&quot;dynamicOptions&quot;: {
&quot;border&quot;: {
&quot;enabled&quot;: false,
&quot;position&quot;: &quot;bottom&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 4.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
}
},
&quot;solidOptions&quot;: {
&quot;headerOpacity&quot;: {
&quot;unit&quot;: &quot;%&quot;,
&quot;value&quot;: 100.0
},
&quot;border&quot;: {
&quot;enabled&quot;: false,
&quot;position&quot;: &quot;bottom&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 4.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;dropShadow&quot;: {
&quot;enabled&quot;: false,
&quot;blur&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 30.0
},
&quot;spread&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;distance&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;blurBackground&quot;: {
&quot;enabled&quot;: false,
&quot;blurRadius&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
}
},
&quot;backgroundColor&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;white&quot;,
&quot;alphaModifier&quot;: 1.0
}
},
&quot;navigationColor&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;gradientOptions&quot;: {
&quot;gradientType&quot;: &quot;faded&quot;,
&quot;headerOpacity&quot;: {
&quot;unit&quot;: &quot;%&quot;,
&quot;value&quot;: 90.0
},
&quot;border&quot;: {
&quot;enabled&quot;: false,
&quot;position&quot;: &quot;bottom&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 4.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;dropShadow&quot;: {
&quot;enabled&quot;: false,
&quot;blur&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 30.0
},
&quot;spread&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;distance&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;color&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;blurBackground&quot;: {
&quot;enabled&quot;: false,
&quot;blurRadius&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
}
},
&quot;backgroundColor&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;white&quot;,
&quot;alphaModifier&quot;: 1.0
}
},
&quot;navigationColor&quot;: {
&quot;type&quot;: &quot;SITE_PALETTE_COLOR&quot;,
&quot;sitePaletteColor&quot;: {
&quot;colorName&quot;: &quot;black&quot;,
&quot;alphaModifier&quot;: 1.0
}
}
},
&quot;dropShadowOptions&quot;: {
&quot;enabled&quot;: false,
&quot;blur&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
},
&quot;spread&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 0.0
},
&quot;distance&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
}
},
&quot;borderOptions&quot;: {
&quot;enabled&quot;: false,
&quot;position&quot;: &quot;bottom&quot;,
&quot;thickness&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 4.0
}
},
&quot;showPromotedElement&quot;: false,
&quot;buttonVariant&quot;: &quot;primary&quot;,
&quot;blurBackground&quot;: {
&quot;enabled&quot;: false,
&quot;blurRadius&quot;: {
&quot;unit&quot;: &quot;px&quot;,
&quot;value&quot;: 12.0
}
},
&quot;headerOpacity&quot;: {
&quot;unit&quot;: &quot;%&quot;,
&quot;value&quot;: 100.0
}
}"
                data-section-id="overlay-nav" data-show-account-login="true" data-test="header-menu">
                <div class="header-menu-bg theme-bg--primary"></div>
                <div class="header-menu-nav">
                    <nav class="header-menu-nav-list">
                        <div data-folder="root" class="header-menu-nav-folder">
                            <div class="header-menu-nav-folder-content">
                                <!-- Menu Navigation -->
                                <div class="header-menu-nav-wrapper">
                                    <div
                                        class="container header-menu-nav-item header-menu-nav-item--collection header-nav--menuitem--homepage header-menu-nav-item--active">
                                        <a href="<?php echo e(url('/')); ?>" data-animation-role="header-element"
                                            aria-current="page">
                                            <div class="header-menu-nav-item-content">
                                                Home
                                            </div>
                                        </a>
                                    </div>
                                    <div class="container header-menu-nav-item header-menu-nav-item--collection">
                                        <a href="<?php echo e(url('about-us')); ?>" data-animation-role="header-element">
                                            <div class="header-menu-nav-item-content">
                                                About
                                            </div>
                                        </a>
                                    </div>
                                    <div class="container header-menu-nav-item header-menu-nav-item--collection">
                                        <a href="<?php echo e(url('pricing')); ?>" data-animation-role="header-element">
                                            <div class="header-menu-nav-item-content">
                                                Pricing
                                            </div>
                                        </a>
                                    </div>
                                    <div class="container header-menu-nav-item header-menu-nav-item--collection">
                                        <a href="<?php echo e(url('contact-us')); ?>" data-animation-role="header-element">
                                            <div class="header-menu-nav-item-content">
                                                Contact
                                            </div>
                                        </a>
                                    </div>
                                    <div class="container header-menu-nav-item">
                                        <a data-folder-id="/markets" href="#">
                                            <div class="header-menu-nav-item-content">
                                                <span class="visually-hidden">Folder:</span>
                                                <span>Markets</span>
                                                <span class="chevron chevron--right"></span>
                                            </div>
                                        </a>
                                    </div>
                                    <div data-folder="/markets" class="header-menu-nav-folder">
                                        <div class="header-menu-nav-folder-content">
                                            <div class="header-menu-controls container header-menu-nav-item">
                                                <a class="header-menu-controls-control header-menu-controls-control--active"
                                                    data-action="back" href="<?php echo e(url('/')); ?>">
                                                    <span class="chevron chevron--left"></span><span>Back</span>
                                                </a>
                                            </div>
                                            <div class="header-nav-folder-content">
                                                <div class="container header-menu-nav-item">
                                                    <a href="<?php echo e(url('markets/forex')); ?>">
                                                        <div class="header-menu-nav-item-content">
                                                            Forex
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="container header-menu-nav-item">
                                                    <a href="<?php echo e(url('markets/indices')); ?>">
                                                        <div class="header-menu-nav-item-content">
                                                            Indices
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="container header-menu-nav-item">
                                                    <a href="<?php echo e(url('markets/commodities')); ?>">
                                                        <div class="header-menu-nav-item-content">
                                                            Commodities
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="container header-menu-nav-item">
                                                    <a href="<?php echo e(url('markets/shares')); ?>">
                                                        <div class="header-menu-nav-item-content">
                                                            Shares
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="container header-menu-nav-item">
                                                    <a href="<?php echo e(url('markets/cryptocurrency')); ?>">
                                                        <div class="header-menu-nav-item-content">
                                                            Cryptocurrencies
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="container header-menu-nav-item">
                                                    <a href="<?php echo e(url('markets/economic-calender')); ?>">
                                                        <div class="header-menu-nav-item-content">
                                                            Economic Calender
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(Auth::user()): ?>
                                        <div class="header-nav-item header-nav-item--collection">
                                            <a href="<?php echo e(url('user/dashboard')); ?>"
                                                class="sqs-block-button-element--small sqs-button-element--tertiary sqs-block-button-element"
                                                style="padding:10px;">
                                                Dashboard
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div class="header-nav-item header-nav-item--collection">
                                            <a href="<?php echo e(url('register')); ?>"
                                                class="sqs-block-button-element--small sqs-button-element--tertiary sqs-block-button-element"
                                                style="padding:10px;">
                                                Join Us
                                            </a>
                                        </div>
                                        <div class="header-nav-item header-nav-item--collection">
                                            <a href="<?php echo e(url('login')); ?>"
                                                class="sqs-block-button-element--small sqs-button-element--tertiary sqs-block-button-element"
                                                style="padding:10px;">
                                                Login
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </nav>

                </div>
            </div>
        </header>





        <?php echo $__env->yieldPushContent('content'); ?>



        <script type="text/javascript">
            const firstSection = document.querySelector('.page-section');
            const header = document.querySelector('.header');
            const mobileOverlayNav = document.querySelector('.header-menu');
            const sectionBackground = firstSection ? firstSection.querySelector('.section-background') : null;
            const headerHeight = header ? header.getBoundingClientRect().height : 0;
            const firstSectionHasBackground = firstSection ? firstSection.className.indexOf('has-background') >= 0 : false;
            const isFirstSectionInset = firstSection ? firstSection.className.indexOf('background-width--inset') >= 0 : false;
            const isLayoutEngineSection = firstSection ? firstSection.className.indexOf('layout-engine-section') >= 0 : false;

            if (firstSection) {
                firstSection.style.paddingTop = headerHeight + 'px';
            }
            if (sectionBackground && isLayoutEngineSection) {
                if (isFirstSectionInset) {
                    sectionBackground.style.top = headerHeight + 'px';
                } else {
                    sectionBackground.style.top = '';
                }
            }
            //# sourceURL=headerPositioning.js
        </script>
        <style>
            .overflowWrap {
                overflow: auto;
                scrollbar-width: thin;
            }

            .overflowWrap {
                max-width: calc(100vw - 32px);
            }

            .cc-logos {
                display: grid;
                grid-auto-flow: column;
                align-items: center;
                gap: 8px;
                height: 48px;
            }

            @media screen and (min-width: 768px) {
                .cc-logos {
                    height: 64px;
                }
            }

            .cc-logos__item {
                width: -webkit-max-content;
                width: -moz-max-content;
                width: max-content;
                min-width: calc((100vw - 32px - 24px)/ 3.5);
                filter: grayscale(1);
                opacity: .7;
            }

            @media screen and (min-width: 768px) {
                .cc-logos__item {
                    min-width: 128px;
                }
            }

            .cplzd {
                min-height: 0 !important;
            }

            .cc-logos img {
                display: block;
                min-height: 0;
                margin: 0 auto;
                transform: scale(.75);
            }

            @media screen and (min-width: 768px) {
                .cc-logos img {
                    transform: scale(1);
                }
            }
        </style>
      
        <footer class="sections" id="footer-sections" data-footer-sections>
            <section data-test="page-section" data-section-theme="dark"
                class='page-section layout-engine-section background-width--full-bleed section-height--small content-width--medium horizontal-alignment--left vertical-alignment--middle has-background dark'
                data-section-id="5ef307d22fa30c1d8014f940" data-controller="SectionWrapperController"
                data-current-styles="{
    &quot;backgroundImage&quot;: {
    &quot;id&quot;: &quot;5ef32c3d37cfa455b6ed307a&quot;,
    &quot;recordType&quot;: 2,
    &quot;addedOn&quot;: 1592994877001,
    &quot;updatedOn&quot;: 1592994887164,
    &quot;workflowState&quot;: 1,
    &quot;publishOn&quot;: 1592994877001,
    &quot;authorId&quot;: &quot;5ef307cf6404f655d679db14&quot;,
    &quot;systemDataId&quot;: &quot;1592994877025-94NE3KJEDTKMA1GL04D0&quot;,
    &quot;systemDataVariants&quot;: &quot;2500x1406,100w,300w,500w,750w,1000w,1500w,2500w&quot;,
    &quot;systemDataSourceType&quot;: &quot;JPG&quot;,
    &quot;mediaFocalPoint&quot;: {
    &quot;x&quot;: 0.5,
    &quot;y&quot;: 0.5,
    &quot;source&quot;: 3
    },
    &quot;colorData&quot;: {
    &quot;topLeftAverage&quot;: &quot;020202&quot;,
    &quot;topRightAverage&quot;: &quot;616161&quot;,
    &quot;bottomLeftAverage&quot;: &quot;080808&quot;,
    &quot;bottomRightAverage&quot;: &quot;303030&quot;,
    &quot;centerAverage&quot;: &quot;464646&quot;,
    &quot;suggestedBgColor&quot;: &quot;030303&quot;
    },
    &quot;urlId&quot;: &quot;ovkzpyqxs2ytl8y3qu93prw18l8jsk&quot;,
    &quot;title&quot;: &quot;&quot;,
    &quot;body&quot;: null,
    &quot;likeCount&quot;: 0,
    &quot;commentCount&quot;: 0,
    &quot;publicCommentCount&quot;: 0,
    &quot;commentState&quot;: 2,
    &quot;unsaved&quot;: false,
    &quot;author&quot;: {
    &quot;id&quot;: &quot;5ef307cf6404f655d679db14&quot;,
    &quot;displayName&quot;: &quot;Günter Höllerl&quot;,
    &quot;firstName&quot;: &quot;Günter&quot;,
    &quot;lastName&quot;: &quot;Höllerl&quot;,
    &quot;bio&quot;: &quot;&quot;
    },
    &quot;assetUrl&quot;: &quot;images/image-asset.jpeg&quot;,
    &quot;contentType&quot;: &quot;image/jpeg&quot;,
    &quot;items&quot;: [ ],
    &quot;pushedServices&quot;: { },
    &quot;pendingPushedServices&quot;: { },
    &quot;recordTypeLabel&quot;: &quot;image&quot;,
    &quot;originalSize&quot;: &quot;2500x1406&quot;
    },
    &quot;imageOverlayOpacity&quot;: 0.54,
    &quot;backgroundWidth&quot;: &quot;background-width--full-bleed&quot;,
    &quot;sectionHeight&quot;: &quot;section-height--small&quot;,
    &quot;customSectionHeight&quot;: 40,
    &quot;horizontalAlignment&quot;: &quot;horizontal-alignment--left&quot;,
    &quot;verticalAlignment&quot;: &quot;vertical-alignment--middle&quot;,
    &quot;contentWidth&quot;: &quot;content-width--medium&quot;,
    &quot;customContentWidth&quot;: 100,
    &quot;sectionTheme&quot;: &quot;dark&quot;,
    &quot;sectionAnimation&quot;: &quot;none&quot;,
    &quot;backgroundMode&quot;: &quot;image&quot;
    }"
                data-current-context="{
    &quot;video&quot;: {
    &quot;playbackSpeed&quot;: 0.5,
    &quot;filter&quot;: 1,
    &quot;filterStrength&quot;: 0,
    &quot;zoom&quot;: 0,
    &quot;videoSourceProvider&quot;: &quot;none&quot;
    },
    &quot;backgroundImageId&quot;: null,
    &quot;backgroundMediaEffect&quot;: null,
    &quot;divider&quot;: null,
    &quot;typeName&quot;: &quot;page&quot;
    }"
                data-animation="none">
                <div class="section-border">
                    <div class="section-background">
                        <img alt="" data-src="/images/image-asset.jpeg" data-image="/images/image-asset.jpeg"
                            data-image-dimensions="2500x1406" data-image-focal-point="0.5,0.5" data-load="false"
                            elementtiming="nbf-background" src="/images/image-asset.jpeg" width="2500"
                            height="1406" sizes="(max-width: 799px) 200vw, 100vw"
                            style="display:block;object-position: 50% 50%" fetchpriority="high" loading="eager"
                            decoding="async" data-loader="sqs">
                        <div class="section-background-overlay" style="opacity: 0.54;"></div>
                    </div>
                </div>
                <div class='content-wrapper' style=''>
                    <div class="content">
                        <div class="sqs-layout sqs-grid-12 columns-12" data-type="page-section"
                            id="page-section-5ef307d22fa30c1d8014f940">
                            <div class="row sqs-row">
                                <div class="col sqs-col-12 span-12">
                                    <div class="sqs-block html-block sqs-block-html" data-block-type="2"
                                        id="block-391662a61a9987263b4e">
                                        <div class="sqs-block-content">
                                            <div class="sqs-html-content">
                                                <h3 style="white-space:pre-wrap;"><?php echo e(get_settings('website_name')); ?></h3>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row sqs-row">
                                        <div class="col sqs-col-4 span-4">
                                            <div class="sqs-block html-block sqs-block-html" data-block-type="2"
                                                id="block-489ffddc391acba2d1b0">
                                                <div class="sqs-block-content">
                                                    <div class="sqs-html-content">
                                                        <p class="" style="white-space:pre-wrap;"><?php echo e(get_settings('official_address')); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <style>
                                                .sqs-disclaimer-link {
                                                    background-repeat: unset;
                                                    background-image: unset;
                                                    background-size: unset;
                                                    background-position: unset;
                                                    text-decoration-line: underline;
                                                    text-decoration-style: solid;
                                                    text-decoration-color: currentColor;
                                                    text-decoration-thickness: 1px;
                                                    text-underline-offset: .2em;
                                                    text-decoration-skip: auto;
                                                    text-decoration-skip-ink: auto;
                                                }
                                            </style>
                                            <div class="sqs-block button-block sqs-block-button" data-block-type="53"
                                                id="block-yui_3_17_2_1_1593435203770_5775">
                                                <div class="sqs-block-content">
                                                    <div class="sqs-block-button-container sqs-block-button-container--left sqs-html-content"
                                                        data-animation-role="button" data-alignment="left"
                                                        data-button-size="small" data-button-type="tertiary"
                                                        style="width: max-content;">
                                                        <a href="terms"
                                                            class="sqs-disclaimer-link">Terms and Condition</a>
                                                        <a href="policy"
                                                            class="sqs-disclaimer-link"
                                                            style="padding-left: 10px">Privacy Policy</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col sqs-col-8 span-8">
                                            <div class="sqs-block html-block sqs-block-html" data-block-type="2"
                                                id="block-26f93cdd88124b49a77e">
                                                <div class="sqs-block-content">
                                                    <div class="sqs-html-content">
                                                        <p class="" style="white-space:pre-wrap;">E: <?php echo e(get_settings('official_email')); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </footer>
    </div>

    <script defer="defer" src="js/site-bundle.js" type="text/javascript"></script>
    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" style="display:none" data-usage="social-icons-svg">
        <symbol id="email-icon" viewBox="0 0 64 64">
            <path d="M17,22v20h30V22H17z M41.1,25L32,32.1L22.9,25H41.1z M20,39V26.6l12,9.3l12-9.3V39H20z" />
        </symbol>
        <symbol id="email-mask" viewBox="0 0 64 64">
            <path
                d="M41.1,25H22.9l9.1,7.1L41.1,25z M44,26.6l-12,9.3l-12-9.3V39h24V26.6z M0,0v64h64V0H0z M47,42H17V22h30V42z" />
        </symbol>
        <symbol id="linkedin-unauth-icon" viewBox="0 0 64 64">
            <path
                d="M20.4,44h5.4V26.6h-5.4V44z M23.1,18c-1.7,0-3.1,1.4-3.1,3.1c0,1.7,1.4,3.1,3.1,3.1 c1.7,0,3.1-1.4,3.1-3.1C26.2,19.4,24.8,18,23.1,18z M39.5,26.2c-2.6,0-4.4,1.4-5.1,2.8h-0.1v-2.4h-5.2V44h5.4v-8.6 c0-2.3,0.4-4.5,3.2-4.5c2.8,0,2.8,2.6,2.8,4.6V44H46v-9.5C46,29.8,45,26.2,39.5,26.2z" />
        </symbol>
        <symbol id="linkedin-unauth-mask" viewBox="0 0 64 64">
            <path
                d="M0,0v64h64V0H0z M25.8,44h-5.4V26.6h5.4V44z M23.1,24.3c-1.7,0-3.1-1.4-3.1-3.1c0-1.7,1.4-3.1,3.1-3.1 c1.7,0,3.1,1.4,3.1,3.1C26.2,22.9,24.8,24.3,23.1,24.3z M46,44h-5.4v-8.4c0-2,0-4.6-2.8-4.6c-2.8,0-3.2,2.2-3.2,4.5V44h-5.4V26.6 h5.2V29h0.1c0.7-1.4,2.5-2.8,5.1-2.8c5.5,0,6.5,3.6,6.5,8.3V44z" />
        </symbol>
    </svg>


    <script>
        class PlanSwitchController extends Stimulus.Controller {
            static targets = ["content", "cursor"];
            static classes = ["active", "hidden", "highlight"]
            static values = {
                initial: Number
            };

            connect() {
                this.cursorTarget.classList.add(...this.highlightClasses);

                this.showContent(this.initialValue);
            }

            toggleContent({
                target,
                params
            }) {
                this.cursorTargets.forEach(content => {
                    content.classList.remove(...this.highlightClasses);
                });

                target.classList.add(...this.highlightClasses);

                this.showContent(params.category);
            }

            showContent(contentNumber) {
                this.contentTargets.forEach(content => {
                    const contentValue = Number(
                        content.getAttribute("data-category")
                    );

                    if (contentValue === contentNumber) {
                        content.classList.add(this.activeClass);
                        content.classList.remove(this.hiddenClass);
                    } else {
                        content.classList.remove(this.activeClass);
                        content.classList.add(this.hiddenClass);
                    }
                });
            }
        }

        Stimulus.Application.start().register("plan-switch", PlanSwitchController);
    </script>

</body>

</html>
<?php /**PATH /Users/user/Documents/Developement/blocktraderinvestments/resources/views/layout/front.blade.php ENDPATH**/ ?>